/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile.core;

import com.zurrtum.create.client.flywheel.backend.compile.FlwPrograms;
import com.zurrtum.create.client.flywheel.backend.compile.core.Compilation;
import com.zurrtum.create.client.flywheel.backend.compile.core.CompilationHarness;
import com.zurrtum.create.client.flywheel.backend.compile.core.ProgramLinker;
import com.zurrtum.create.client.flywheel.backend.compile.core.ShaderCache;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlShader;
import com.zurrtum.create.client.flywheel.backend.gl.shader.ShaderType;
import com.zurrtum.create.client.flywheel.backend.glsl.GlslVersion;
import com.zurrtum.create.client.flywheel.backend.glsl.ShaderSources;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceComponent;
import com.zurrtum.create.client.flywheel.lib.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class Compile<K> {
    public ShaderCompiler<K> shader(GlslVersion glslVersion, ShaderType shaderType) {
        return new ShaderCompiler(glslVersion, shaderType);
    }

    public ProgramStitcher<K> program() {
        return new ProgramStitcher();
    }

    @Environment(value=EnvType.CLIENT)
    public static class ShaderCompiler<K> {
        private final GlslVersion glslVersion;
        private final ShaderType shaderType;
        private final List<BiFunction<K, ShaderSources, SourceComponent>> fetchers = new ArrayList<BiFunction<K, ShaderSources, SourceComponent>>();
        private BiConsumer<K, Compilation> compilationCallbacks = ($, $$) -> {};
        private Function<K, String> nameMapper = Object::toString;

        public ShaderCompiler(GlslVersion glslVersion, ShaderType shaderType) {
            this.glslVersion = glslVersion;
            this.shaderType = shaderType;
        }

        public ShaderCompiler<K> nameMapper(Function<K, String> nameMapper) {
            this.nameMapper = nameMapper;
            return this;
        }

        public ShaderCompiler<K> with(BiFunction<K, ShaderSources, SourceComponent> fetch) {
            this.fetchers.add(fetch);
            return this;
        }

        public ShaderCompiler<K> withComponents(Collection<SourceComponent> components) {
            components.forEach(this::withComponent);
            return this;
        }

        public ShaderCompiler<K> withComponent(SourceComponent component) {
            return this.withComponent((K $) -> component);
        }

        public ShaderCompiler<K> withComponent(Function<K, SourceComponent> sourceFetcher) {
            return this.with((key, $) -> (SourceComponent)sourceFetcher.apply(key));
        }

        public ShaderCompiler<K> withResource(Function<K, class_2960> sourceFetcher) {
            return this.with((key, loader) -> loader.get((class_2960)sourceFetcher.apply(key)));
        }

        public ShaderCompiler<K> withResource(class_2960 Identifier) {
            return this.withResource((K $) -> Identifier);
        }

        public ShaderCompiler<K> onCompile(BiConsumer<K, Compilation> cb) {
            this.compilationCallbacks = this.compilationCallbacks.andThen(cb);
            return this;
        }

        public ShaderCompiler<K> define(String def, int value) {
            return this.onCompile(($, ctx) -> ctx.define(def, String.valueOf(value)));
        }

        public ShaderCompiler<K> enableExtension(String extension) {
            return this.onCompile(($, ctx) -> ctx.enableExtension(extension));
        }

        public ShaderCompiler<K> enableExtensions(String ... extensions) {
            return this.onCompile(($, ctx) -> {
                for (String extension : extensions) {
                    ctx.enableExtension(extension);
                }
            });
        }

        public ShaderCompiler<K> enableExtensions(Collection<String> extensions) {
            return this.onCompile(($, ctx) -> {
                for (String extension : extensions) {
                    ctx.enableExtension(extension);
                }
            });
        }

        public ShaderCompiler<K> requireExtensions(Collection<String> extensions) {
            return this.onCompile(($, ctx) -> {
                for (String extension : extensions) {
                    ctx.requireExtension(extension);
                }
            });
        }

        private GlShader compile(K key, ShaderCache compiler, ShaderSources loader) {
            long start = System.nanoTime();
            ArrayList<SourceComponent> components = new ArrayList<SourceComponent>();
            for (BiFunction<K, ShaderSources, SourceComponent> fetcher : this.fetchers) {
                components.add(fetcher.apply(key, loader));
            }
            Consumer<Compilation> cb = ctx -> this.compilationCallbacks.accept(key, (Compilation)ctx);
            String name = this.nameMapper.apply(key);
            GlShader out = compiler.compile(this.glslVersion, this.shaderType, name, cb, components);
            long end = System.nanoTime();
            FlwPrograms.LOGGER.debug("Compiled {} in {}", (Object)name, (Object)StringUtil.formatTime(end - start));
            return out;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ProgramStitcher<K>
    implements CompilationHarness.KeyCompiler<K> {
        private final Map<ShaderType, ShaderCompiler<K>> compilers = new EnumMap<ShaderType, ShaderCompiler<K>>(ShaderType.class);
        private BiConsumer<K, GlProgram> postLink = (k, p) -> {};
        private BiConsumer<K, GlProgram> preLink = (k, p) -> {};

        public CompilationHarness<K> harness(String marker, ShaderSources sources) {
            return new CompilationHarness(marker, sources, this);
        }

        public ProgramStitcher<K> link(ShaderCompiler<K> compilerBuilder) {
            if (this.compilers.containsKey((Object)compilerBuilder.shaderType)) {
                throw new IllegalArgumentException("Duplicate shader type: " + String.valueOf((Object)compilerBuilder.shaderType));
            }
            this.compilers.put(compilerBuilder.shaderType, compilerBuilder);
            return this;
        }

        public ProgramStitcher<K> postLink(BiConsumer<K, GlProgram> postLink) {
            this.postLink = postLink;
            return this;
        }

        public ProgramStitcher<K> preLink(BiConsumer<K, GlProgram> preLink) {
            this.preLink = preLink;
            return this;
        }

        @Override
        public GlProgram compile(K key, ShaderSources loader, ShaderCache shaderCache, ProgramLinker programLinker) {
            if (this.compilers.isEmpty()) {
                throw new IllegalStateException("No shader compilers were added!");
            }
            long start = System.nanoTime();
            ArrayList<GlShader> shaders = new ArrayList<GlShader>();
            for (ShaderCompiler<K> compiler : this.compilers.values()) {
                shaders.add(compiler.compile(key, shaderCache, loader));
            }
            GlProgram out = programLinker.link(shaders, p -> this.preLink.accept(key, (GlProgram)p));
            this.postLink.accept(key, out);
            long end = System.nanoTime();
            FlwPrograms.LOGGER.debug("Linked {} in {}", key, (Object)StringUtil.formatTime(end - start));
            return out;
        }
    }
}

